/*******************************************************************
*
*  DESCRIPTION: Atomic Model Faculty
*
*  AUTHOR: Srivastav Janapalli
*
*  EMAIL: sjana086@uottawa.ca
*
*  DATE: 30/10/2016
*
*******************************************************************/

/** include files **/
#include "faculty.h"      // class faculty
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )
#include <time.h>    // time()


/** public functions **/

/*******************************************************************
* Function Name: Faculty
* Description:
********************************************************************/
Faculty::Faculty( const string &name )
: Atomic( name )
, applicationCourseCheck( addInputPort( "applicationCourseCheck" ) )
, facultyOUT( addOutputPort( "facultyOUT" ) )
, advisorOpinionOUT( addOutputPort( "advisorOpinionOUT" ) )
, facultyTime( 0, 0, 10, 0 )
{

}

/*******************************************************************
* Function Name: initFunction
* Description: define the initial state
* Precondition: the model should be passive
********************************************************************/
Model &Faculty::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Faculty::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == applicationCourseCheck  && this->state() == passive)
	{	checkFacultyNum = static_cast < int > ( msg.value());
		checkNum = checkFacultyNum & '?' ;
		if (checkNum != '1')
		{
			qualify = true;
			holdIn( active, facultyTime );
		}
		else{
			qualify = false;
			holdIn( active, facultyTime );
		}
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Faculty::internalFunction( const InternalMessage & )
{
	passivate();

	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Faculty::outputFunction( const InternalMessage &msg )
{	if (qualify)
	{	sendOutput( msg.time(), facultyOUT, checkFacultyNum ) ;

	}
	else // if you have recommendations !!!!!
	{
		if ((double)rand() / (double) RAND_MAX  > 0.70)
		{
			sendOutput( msg.time(), facultyOUT, checkFacultyNum ) ;
		}
		else
			sendOutput ( msg.time(), advisorOpinionOUT, checkFacultyNum);

	}
	return *this ;
}

